//-------------------------------------CAPTION + LOG file--------------------------------------------------

// This is a program written for the Dark Energy from Theory to Observation Group - Spring 2015
// This program is updated for class of Special Topics in Cosmology - Fall 2015 - Physics Department SUT
// This program calculate the distance modulus of SNe theoreticaly and compare it with the observational data
// In order to find the statistical significance of the models  and find the best parameters of the model.

// *Version:1  *Date:3 March  *Filename:cosmo-sne-3Mar2015.cpp *Edited by:Shant Baghram
// *Version:2  *Date:6 March  *Filename:cosmo-sne-6Mar2015.cpp *Edited by Shant Baghram (Liklihood function is added)
// *Version:3  *Date:25 September *Filename:sne-Sep2015-SB.cpp *Edited by Shant Baghram For Special Topics in Cosmology Class - Fall 2015
// PILOT VERSION: *Date:25 September *Filename:sne-pilot-Sep2015-SB.cpp *Edited by Shant Baghram For Special Topics in Cosmology Class - Fall 2015

// IN developments of Codes . Mr. Farbod Hassani From Physics Department of SUT collaborates
// You can visit his web-page for more Information: http://farbod-hassani.com/



//------------------------------------LIBRARIES-------------------------------------------------

// In this section the required libraries are added by their headers name.


#include  "cosmology-sub-Sep2015-SB.h"   // This is a sub-routine written by me for cosological functions
#include "stdlib.h"
#include "stdio.h"
#include "math.h"
#include "iostream"
#include "stdlib.h"
#include "time.h"	
#include <complex>
#include "cmath"
#include "cstdlib"
using namespace std;




//-------------------------------Defines ---------------------------------------------------------

#define PI 3.141592


//-------------------------------Main Program-------------------------------------------------



int main ()

{


cout<<"Hello" <<endl;


//***************************** Definition of structures ************************************


  struct data {
  float  z[1000], mu[1000], sigma[1000]; // redshift, distance modulus, error z (Gold Sample) 
};



//*****STRUCTURAL PARAMETERS*************

 data sne;


//****************************** Parameter Definition ***********************************

double Omega_m,Omega_r,Omega_L,Omega_cdm,Omega_b, Omega_k, A_inf, ns,  kpivot, sigma8 , h;  // Cosmological parameters

double mu;  // theoretical distance modulus
double DL;  // Luminosity distance

double Xisquare;            // The statistical estimator Xi^2
int numberSNe, numberSNejla;              // NUmber of SNe in catalog - Union and JLA

//**************************** INPUT-OUTPUT FILES ******************************************   
 FILE* Resultunion;
 Resultunion=fopen("Resultu1.txt","w");

   
 FILE* Resultjla;
 Resultjla=fopen("Resultj1.txt","w");


//****************************READING FILES **************************************************


FILE* INPUTSNeUnion;
INPUTSNeUnion=fopen("union2.txt","r");     
// This file contains the 1)SNe name 2)redshift of SNe 3)Distance modulus 4)Error in distance modulus

FILE* INPUTSNeJLA;
INPUTSNeJLA=fopen("jla.txt","r");     
// This file contains the 1)redshift of SNe 2)Distance modulus 3)Error in distance modulus

//********************** INITIAL VALUES ************************************



Xisquare=0.0 ;  // initial value of Xi^2
numberSNe=557;   // number of SNe in Union.2 data
numberSNejla=740;   // number of SNe in Union.2 data


// **** SCDM Cosmological parameters *****

//Omega_m=1.0;      // Matter  desity parameter value set : Best value
//Omega_L=0.0;     // Cosmological constant value set



// **** PLANCK Cosmological parameters *****
//Ref: Planck 2015 results. XIII. Cosmological parameters - arXiv:1502.01589 - TT,TE,EE+lowP+lensing best parameters

Omega_m=0.3121;      // Matter  desity parameter value set : Best value
Omega_L=0.6879;     // Cosmological constant value set

// ***************************************************************************

h=0.6751;           // Hubble parameter  h= H_0 / 100

//h=0.720;           // Hubble parameter  h= H_0 / 100

Omega_cdm=0.1193/square(h);   //Cold Dark matter density parameter is fixed   
Omega_b=0.02226/square(h);     // The baryon density parameter is fixed    0.02226  

Omega_r=1e-5;
Omega_k=0.000;

A_inf=2.130e-9;    // COBE normalization best parameter
kpivot=0.05;       // Pivot point wavenumber in Mpc^{-1}
ns=0.9653;         //primordial power-spectrum's spectral index

sigma8=0.8150;      // Sigma - 8 Value from data


//***********************************************




  for(int i=1; i< numberSNe+1; ++i)                       // A loop on the SNe data to read it and calculate...
    { 

     fscanf(INPUTSNeUnion,"\n%10f %10f %10f ", &sne.z[i], &sne.mu[i], &sne.sigma[i]);   // A procedure for reading the SNe dat
	
	  


DL=(1.0+ sne.z[i])*Inverse(h)* Chi(Omega_m, Omega_L, Omega_r, h, sne.z[i] );   // Luminosity distance definition in terms of comoving distance


mu=5.0* log10(DL)+25.0 ;     // theoretical distance modulus in terms of luminosity distant


     Xisquare=Xisquare+square(mu-sne.mu[i])/square(sne.sigma[i]);  
          
cout<<" i  = "<<i<<" z =  "<<sne.z[i]<<"  mu = "<<sne.mu[i]<<" sigma = "<< sne.sigma[i]<<endl;   // To check to check to see that the data is read,
	  
fprintf(Resultunion,"\n  %20f %20f %20f %20f",sne.z[i], mu );  



  }
cout<< " *********UNION 2****************"<<endl;


/*




  for(int i=1; i< numberSNejla+1; ++i)                       // A loop on the SNe data to read it and calculate...
    { 

     fscanf(INPUTSNeJLA,"\n%10f %10f %10f ", &sne.z[i], &sne.mu[i], &sne.sigma[i]);   // A procedure for reading the SNe dat
	
	  


DL=(1.0+ sne.z[i])*Inverse(h)* Chi(Omega_m, Omega_L, Omega_r, h, sne.z[i] );   // Luminosity distance definition in terms of comoving distance


mu=5.0* log10(DL)+25.0 ;     // theoretical distance modulus in terms of luminosity distant


     Xisquare=Xisquare+square(mu-sne.mu[i])/square(sne.sigma[i]);            
cout<<" i  = "<<i<<" z =  "<<sne.z[i]<<"  mu = "<<sne.mu[i]<<" sigma = "<< sne.sigma[i]<<endl;   // To check to check to see that the data is read,
	  
fprintf(Resultjla,"\n  %20f %20f %20f %20f",sne.z[i], mu );  



  }










cout<< " ************* JLA ************"<<endl;

*/

cout<<" Omega_m  = "<<Omega_m<<" Omega_L =  "<< Omega_L<<"  Xi^2 = "<< Xisquare<<endl;   // Xi^2 output


  return(0);

}


  
